/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world.feature;

import com.mojang.serialization.Codec;
import dev.toma.gunsrpg.api.common.IGeneratorConfig;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.SimplePlacement;

public class ConfigurablePlacement
extends SimplePlacement<NoPlacementConfig> {
    final Supplier<IGeneratorConfig> cfgSupplier;

    public ConfigurablePlacement(Codec<NoPlacementConfig> codec, Supplier<IGeneratorConfig> cfgSupplier) {
        super(codec);
        this.cfgSupplier = cfgSupplier;
    }

    protected Stream<BlockPos> place(Random random, NoPlacementConfig noPlacementConfig, BlockPos pos) {
        IGeneratorConfig config = this.cfgSupplier.get();
        int attempts = config.getSpawnAttempts();
        return IntStream.range(0, attempts).mapToObj(value -> {
            int configMin = config.getMinHeight();
            int configMax = config.getMaxHeight();
            int delta = configMax - configMin;
            int x = pos.func_177958_n() + random.nextInt(16);
            int y = configMin + random.nextInt(delta);
            int z = pos.func_177952_p() + random.nextInt(16);
            return new BlockPos(x, y, z);
        });
    }
}

